// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge
{
    internal class DiagnosticProactiveLogCollectionSettingOperationSource : IOperationSource<DiagnosticProactiveLogCollectionSettingResource>
    {
        private readonly ArmClient _client;

        internal DiagnosticProactiveLogCollectionSettingOperationSource(ArmClient client)
        {
            _client = client;
        }

        DiagnosticProactiveLogCollectionSettingResource IOperationSource<DiagnosticProactiveLogCollectionSettingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DiagnosticProactiveLogCollectionSettingData.DeserializeDiagnosticProactiveLogCollectionSettingData(document.RootElement);
            return new DiagnosticProactiveLogCollectionSettingResource(_client, data);
        }

        async ValueTask<DiagnosticProactiveLogCollectionSettingResource> IOperationSource<DiagnosticProactiveLogCollectionSettingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DiagnosticProactiveLogCollectionSettingData.DeserializeDiagnosticProactiveLogCollectionSettingData(document.RootElement);
            return new DiagnosticProactiveLogCollectionSettingResource(_client, data);
        }
    }
}
