// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge
{
    internal class DataBoxEdgeTriggerOperationSource : IOperationSource<DataBoxEdgeTriggerResource>
    {
        private readonly ArmClient _client;

        internal DataBoxEdgeTriggerOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataBoxEdgeTriggerResource IOperationSource<DataBoxEdgeTriggerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataBoxEdgeTriggerData.DeserializeDataBoxEdgeTriggerData(document.RootElement);
            return new DataBoxEdgeTriggerResource(_client, data);
        }

        async ValueTask<DataBoxEdgeTriggerResource> IOperationSource<DataBoxEdgeTriggerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataBoxEdgeTriggerData.DeserializeDataBoxEdgeTriggerData(document.RootElement);
            return new DataBoxEdgeTriggerResource(_client, data);
        }
    }
}
