// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge
{
    internal class DataBoxEdgeOrderOperationSource : IOperationSource<DataBoxEdgeOrderResource>
    {
        private readonly ArmClient _client;

        internal DataBoxEdgeOrderOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataBoxEdgeOrderResource IOperationSource<DataBoxEdgeOrderResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataBoxEdgeOrderData.DeserializeDataBoxEdgeOrderData(document.RootElement);
            return new DataBoxEdgeOrderResource(_client, data);
        }

        async ValueTask<DataBoxEdgeOrderResource> IOperationSource<DataBoxEdgeOrderResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataBoxEdgeOrderData.DeserializeDataBoxEdgeOrderData(document.RootElement);
            return new DataBoxEdgeOrderResource(_client, data);
        }
    }
}
