// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDataBoxEdgeArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDataBoxEdgeArmClient"/> class for mocking. </summary>
        protected MockableDataBoxEdgeArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDataBoxEdgeArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDataBoxEdgeArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDataBoxEdgeArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeDeviceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeDeviceResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeDeviceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeDeviceResource"/> object. </returns>
        public virtual DataBoxEdgeDeviceResource GetDataBoxEdgeDeviceResource(ResourceIdentifier id)
        {
            DataBoxEdgeDeviceResource.ValidateResourceId(id);
            return new DataBoxEdgeDeviceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeAlertResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeAlertResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeAlertResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeAlertResource"/> object. </returns>
        public virtual DataBoxEdgeAlertResource GetDataBoxEdgeAlertResource(ResourceIdentifier id)
        {
            DataBoxEdgeAlertResource.ValidateResourceId(id);
            return new DataBoxEdgeAlertResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BandwidthScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BandwidthScheduleResource.CreateResourceIdentifier" /> to create a <see cref="BandwidthScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BandwidthScheduleResource"/> object. </returns>
        public virtual BandwidthScheduleResource GetBandwidthScheduleResource(ResourceIdentifier id)
        {
            BandwidthScheduleResource.ValidateResourceId(id);
            return new BandwidthScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DiagnosticProactiveLogCollectionSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DiagnosticProactiveLogCollectionSettingResource.CreateResourceIdentifier" /> to create a <see cref="DiagnosticProactiveLogCollectionSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DiagnosticProactiveLogCollectionSettingResource"/> object. </returns>
        public virtual DiagnosticProactiveLogCollectionSettingResource GetDiagnosticProactiveLogCollectionSettingResource(ResourceIdentifier id)
        {
            DiagnosticProactiveLogCollectionSettingResource.ValidateResourceId(id);
            return new DiagnosticProactiveLogCollectionSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DiagnosticRemoteSupportSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DiagnosticRemoteSupportSettingResource.CreateResourceIdentifier" /> to create a <see cref="DiagnosticRemoteSupportSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DiagnosticRemoteSupportSettingResource"/> object. </returns>
        public virtual DiagnosticRemoteSupportSettingResource GetDiagnosticRemoteSupportSettingResource(ResourceIdentifier id)
        {
            DiagnosticRemoteSupportSettingResource.ValidateResourceId(id);
            return new DiagnosticRemoteSupportSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeJobResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeJobResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeJobResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeJobResource"/> object. </returns>
        public virtual DataBoxEdgeJobResource GetDataBoxEdgeJobResource(ResourceIdentifier id)
        {
            DataBoxEdgeJobResource.ValidateResourceId(id);
            return new DataBoxEdgeJobResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeOrderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeOrderResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeOrderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeOrderResource"/> object. </returns>
        public virtual DataBoxEdgeOrderResource GetDataBoxEdgeOrderResource(ResourceIdentifier id)
        {
            DataBoxEdgeOrderResource.ValidateResourceId(id);
            return new DataBoxEdgeOrderResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeRoleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeRoleResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeRoleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeRoleResource"/> object. </returns>
        public virtual DataBoxEdgeRoleResource GetDataBoxEdgeRoleResource(ResourceIdentifier id)
        {
            DataBoxEdgeRoleResource.ValidateResourceId(id);
            return new DataBoxEdgeRoleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeRoleAddonResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeRoleAddonResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeRoleAddonResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeRoleAddonResource"/> object. </returns>
        public virtual DataBoxEdgeRoleAddonResource GetDataBoxEdgeRoleAddonResource(ResourceIdentifier id)
        {
            DataBoxEdgeRoleAddonResource.ValidateResourceId(id);
            return new DataBoxEdgeRoleAddonResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MonitoringMetricConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MonitoringMetricConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="MonitoringMetricConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MonitoringMetricConfigurationResource"/> object. </returns>
        public virtual MonitoringMetricConfigurationResource GetMonitoringMetricConfigurationResource(ResourceIdentifier id)
        {
            MonitoringMetricConfigurationResource.ValidateResourceId(id);
            return new MonitoringMetricConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeShareResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeShareResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeShareResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeShareResource"/> object. </returns>
        public virtual DataBoxEdgeShareResource GetDataBoxEdgeShareResource(ResourceIdentifier id)
        {
            DataBoxEdgeShareResource.ValidateResourceId(id);
            return new DataBoxEdgeShareResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeStorageAccountCredentialResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeStorageAccountCredentialResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeStorageAccountCredentialResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeStorageAccountCredentialResource"/> object. </returns>
        public virtual DataBoxEdgeStorageAccountCredentialResource GetDataBoxEdgeStorageAccountCredentialResource(ResourceIdentifier id)
        {
            DataBoxEdgeStorageAccountCredentialResource.ValidateResourceId(id);
            return new DataBoxEdgeStorageAccountCredentialResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeStorageAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeStorageAccountResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeStorageAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeStorageAccountResource"/> object. </returns>
        public virtual DataBoxEdgeStorageAccountResource GetDataBoxEdgeStorageAccountResource(ResourceIdentifier id)
        {
            DataBoxEdgeStorageAccountResource.ValidateResourceId(id);
            return new DataBoxEdgeStorageAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeStorageContainerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeStorageContainerResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeStorageContainerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeStorageContainerResource"/> object. </returns>
        public virtual DataBoxEdgeStorageContainerResource GetDataBoxEdgeStorageContainerResource(ResourceIdentifier id)
        {
            DataBoxEdgeStorageContainerResource.ValidateResourceId(id);
            return new DataBoxEdgeStorageContainerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeTriggerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeTriggerResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeTriggerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeTriggerResource"/> object. </returns>
        public virtual DataBoxEdgeTriggerResource GetDataBoxEdgeTriggerResource(ResourceIdentifier id)
        {
            DataBoxEdgeTriggerResource.ValidateResourceId(id);
            return new DataBoxEdgeTriggerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataBoxEdgeUserResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataBoxEdgeUserResource.CreateResourceIdentifier" /> to create a <see cref="DataBoxEdgeUserResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataBoxEdgeUserResource"/> object. </returns>
        public virtual DataBoxEdgeUserResource GetDataBoxEdgeUserResource(ResourceIdentifier id)
        {
            DataBoxEdgeUserResource.ValidateResourceId(id);
            return new DataBoxEdgeUserResource(Client, id);
        }
    }
}
