// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataBoxEdge.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge
{
    /// <summary>
    /// A class representing the DiagnosticRemoteSupportSetting data model.
    /// The remote support settings of a device.
    /// </summary>
    public partial class DiagnosticRemoteSupportSettingData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticRemoteSupportSettingData"/>. </summary>
        public DiagnosticRemoteSupportSettingData()
        {
            RemoteSupportSettingsList = new ChangeTrackingList<EdgeRemoteSupportSettings>();
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticRemoteSupportSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="remoteSupportSettingsList"> Remote support settings list according to the RemoteApplicationType. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticRemoteSupportSettingData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IList<EdgeRemoteSupportSettings> remoteSupportSettingsList, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            RemoteSupportSettingsList = remoteSupportSettingsList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remote support settings list according to the RemoteApplicationType. </summary>
        public IList<EdgeRemoteSupportSettings> RemoteSupportSettingsList { get; }
    }
}
