// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.DataBoxEdge
{
    /// <summary>
    /// A Class representing a DiagnosticProactiveLogCollectionSetting along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="DiagnosticProactiveLogCollectionSettingResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetDiagnosticProactiveLogCollectionSettingResource method.
    /// Otherwise you can get one from its parent resource <see cref="DataBoxEdgeDeviceResource"/> using the GetDiagnosticProactiveLogCollectionSetting method.
    /// </summary>
    public partial class DiagnosticProactiveLogCollectionSettingResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="DiagnosticProactiveLogCollectionSettingResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="deviceName"> The deviceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string deviceName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/diagnosticProactiveLogCollectionSettings/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics;
        private readonly DiagnosticSettingsRestOperations _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient;
        private readonly DiagnosticProactiveLogCollectionSettingData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.DataBoxEdge/dataBoxEdgeDevices/diagnosticProactiveLogCollectionSettings";

        /// <summary> Initializes a new instance of the <see cref="DiagnosticProactiveLogCollectionSettingResource"/> class for mocking. </summary>
        protected DiagnosticProactiveLogCollectionSettingResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DiagnosticProactiveLogCollectionSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal DiagnosticProactiveLogCollectionSettingResource(ArmClient client, DiagnosticProactiveLogCollectionSettingData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="DiagnosticProactiveLogCollectionSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal DiagnosticProactiveLogCollectionSettingResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DataBoxEdge", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string diagnosticProactiveLogCollectionSettingDiagnosticSettingsApiVersion);
            _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient = new DiagnosticSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, diagnosticProactiveLogCollectionSettingDiagnosticSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DiagnosticProactiveLogCollectionSettingData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the proactive log collection settings of the specified Data Box Edge/Data Box Gateway device.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/diagnosticProactiveLogCollectionSettings/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticSettings_GetDiagnosticProactiveLogCollectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DiagnosticProactiveLogCollectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DiagnosticProactiveLogCollectionSettingResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics.CreateScope("DiagnosticProactiveLogCollectionSettingResource.Get");
            scope.Start();
            try
            {
                var response = await _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.GetDiagnosticProactiveLogCollectionSettingsAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DiagnosticProactiveLogCollectionSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the proactive log collection settings of the specified Data Box Edge/Data Box Gateway device.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/diagnosticProactiveLogCollectionSettings/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticSettings_GetDiagnosticProactiveLogCollectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DiagnosticProactiveLogCollectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DiagnosticProactiveLogCollectionSettingResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics.CreateScope("DiagnosticProactiveLogCollectionSettingResource.Get");
            scope.Start();
            try
            {
                var response = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.GetDiagnosticProactiveLogCollectionSettings(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DiagnosticProactiveLogCollectionSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates the proactive log collection settings on a Data Box Edge/Data Box Gateway device.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/diagnosticProactiveLogCollectionSettings/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticSettings_UpdateDiagnosticProactiveLogCollectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DiagnosticProactiveLogCollectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The proactive log collection settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DiagnosticProactiveLogCollectionSettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, DiagnosticProactiveLogCollectionSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics.CreateScope("DiagnosticProactiveLogCollectionSettingResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.UpdateDiagnosticProactiveLogCollectionSettingsAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, data, cancellationToken).ConfigureAwait(false);
                var operation = new DataBoxEdgeArmOperation<DiagnosticProactiveLogCollectionSettingResource>(new DiagnosticProactiveLogCollectionSettingOperationSource(Client), _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics, Pipeline, _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.CreateUpdateDiagnosticProactiveLogCollectionSettingsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates the proactive log collection settings on a Data Box Edge/Data Box Gateway device.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/diagnosticProactiveLogCollectionSettings/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DiagnosticSettings_UpdateDiagnosticProactiveLogCollectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DiagnosticProactiveLogCollectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The proactive log collection settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DiagnosticProactiveLogCollectionSettingResource> CreateOrUpdate(WaitUntil waitUntil, DiagnosticProactiveLogCollectionSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics.CreateScope("DiagnosticProactiveLogCollectionSettingResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.UpdateDiagnosticProactiveLogCollectionSettings(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, data, cancellationToken);
                var operation = new DataBoxEdgeArmOperation<DiagnosticProactiveLogCollectionSettingResource>(new DiagnosticProactiveLogCollectionSettingOperationSource(Client), _diagnosticProactiveLogCollectionSettingDiagnosticSettingsClientDiagnostics, Pipeline, _diagnosticProactiveLogCollectionSettingDiagnosticSettingsRestClient.CreateUpdateDiagnosticProactiveLogCollectionSettingsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
