// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataBoxEdge.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge
{
    /// <summary>
    /// A class representing the DataBoxEdgeUser data model.
    /// Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
    /// </summary>
    public partial class DataBoxEdgeUserData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUserData"/>. </summary>
        /// <param name="userType"> Type of the user. </param>
        public DataBoxEdgeUserData(DataBoxEdgeUserType userType)
        {
            ShareAccessRights = new ChangeTrackingList<ShareAccessRight>();
            UserType = userType;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUserData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="encryptedPassword"> The password details. </param>
        /// <param name="shareAccessRights"> List of shares that the user has rights on. This field should not be specified during user creation. </param>
        /// <param name="userType"> Type of the user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeUserData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AsymmetricEncryptedSecret encryptedPassword, IReadOnlyList<ShareAccessRight> shareAccessRights, DataBoxEdgeUserType userType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            EncryptedPassword = encryptedPassword;
            ShareAccessRights = shareAccessRights;
            UserType = userType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeUserData"/> for deserialization. </summary>
        internal DataBoxEdgeUserData()
        {
        }

        /// <summary> The password details. </summary>
        public AsymmetricEncryptedSecret EncryptedPassword { get; set; }
        /// <summary> List of shares that the user has rights on. This field should not be specified during user creation. </summary>
        public IReadOnlyList<ShareAccessRight> ShareAccessRights { get; }
        /// <summary> Type of the user. </summary>
        public DataBoxEdgeUserType UserType { get; set; }
    }
}
