// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataBoxEdge.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge
{
    /// <summary>
    /// A class representing the DataBoxEdgeStorageContainer data model.
    /// Represents a container on the  Data Box Edge/Gateway device.
    /// </summary>
    public partial class DataBoxEdgeStorageContainerData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerData"/>. </summary>
        /// <param name="dataFormat"> DataFormat for Container. </param>
        public DataBoxEdgeStorageContainerData(DataBoxEdgeStorageContainerDataFormat dataFormat)
        {
            DataFormat = dataFormat;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerStatus"> Current status of the container. </param>
        /// <param name="dataFormat"> DataFormat for Container. </param>
        /// <param name="refreshDetails"> Details of the refresh job on this container. </param>
        /// <param name="createdOn"> The UTC time when container got created. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEdgeStorageContainerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataBoxEdgeStorageContainerStatus? containerStatus, DataBoxEdgeStorageContainerDataFormat dataFormat, DataBoxEdgeRefreshDetails refreshDetails, DateTimeOffset? createdOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ContainerStatus = containerStatus;
            DataFormat = dataFormat;
            RefreshDetails = refreshDetails;
            CreatedOn = createdOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEdgeStorageContainerData"/> for deserialization. </summary>
        internal DataBoxEdgeStorageContainerData()
        {
        }

        /// <summary> Current status of the container. </summary>
        public DataBoxEdgeStorageContainerStatus? ContainerStatus { get; }
        /// <summary> DataFormat for Container. </summary>
        public DataBoxEdgeStorageContainerDataFormat DataFormat { get; set; }
        /// <summary> Details of the refresh job on this container. </summary>
        public DataBoxEdgeRefreshDetails RefreshDetails { get; }
        /// <summary> The UTC time when container got created. </summary>
        public DateTimeOffset? CreatedOn { get; }
    }
}
