// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataBoxEdge.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge
{
    public partial class DataBoxEdgeStorageAccountData : IUtf8JsonSerializable, IJsonModel<DataBoxEdgeStorageAccountData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataBoxEdgeStorageAccountData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataBoxEdgeStorageAccountData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeStorageAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEdgeStorageAccountData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(StorageAccountStatus))
            {
                writer.WritePropertyName("storageAccountStatus"u8);
                writer.WriteStringValue(StorageAccountStatus.Value.ToString());
            }
            writer.WritePropertyName("dataPolicy"u8);
            writer.WriteStringValue(DataPolicy.ToString());
            if (Optional.IsDefined(StorageAccountCredentialId))
            {
                writer.WritePropertyName("storageAccountCredentialId"u8);
                writer.WriteStringValue(StorageAccountCredentialId);
            }
            if (options.Format != "W" && Optional.IsDefined(BlobEndpoint))
            {
                writer.WritePropertyName("blobEndpoint"u8);
                writer.WriteStringValue(BlobEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(ContainerCount))
            {
                writer.WritePropertyName("containerCount"u8);
                writer.WriteNumberValue(ContainerCount.Value);
            }
            writer.WriteEndObject();
        }

        DataBoxEdgeStorageAccountData IJsonModel<DataBoxEdgeStorageAccountData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeStorageAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEdgeStorageAccountData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataBoxEdgeStorageAccountData(document.RootElement, options);
        }

        internal static DataBoxEdgeStorageAccountData DeserializeDataBoxEdgeStorageAccountData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            DataBoxEdgeStorageAccountStatus? storageAccountStatus = default;
            DataBoxEdgeDataPolicy dataPolicy = default;
            ResourceIdentifier storageAccountCredentialId = default;
            string blobEndpoint = default;
            int? containerCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("storageAccountStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageAccountStatus = new DataBoxEdgeStorageAccountStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dataPolicy"u8))
                        {
                            dataPolicy = new DataBoxEdgeDataPolicy(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("storageAccountCredentialId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageAccountCredentialId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("blobEndpoint"u8))
                        {
                            blobEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("containerCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            containerCount = property0.Value.GetInt32();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataBoxEdgeStorageAccountData(
                id,
                name,
                type,
                systemData,
                description,
                storageAccountStatus,
                dataPolicy,
                storageAccountCredentialId,
                blobEndpoint,
                containerCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataBoxEdgeStorageAccountData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeStorageAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataBoxEdgeStorageAccountData)} does not support writing '{options.Format}' format.");
            }
        }

        DataBoxEdgeStorageAccountData IPersistableModel<DataBoxEdgeStorageAccountData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEdgeStorageAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataBoxEdgeStorageAccountData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataBoxEdgeStorageAccountData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataBoxEdgeStorageAccountData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
