// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataBoxEdge.Models;

namespace Azure.ResourceManager.DataBoxEdge.Samples
{
    public partial class Sample_MonitoringMetricConfigurationResource
    {
        // GetMonitoringConfig
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetMonitoringConfig()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GetMonitoringConfig.json
            // this example is just showing the usage of "MonitoringConfig_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoringMetricConfigurationResource created on azure
            // for more information of creating MonitoringMetricConfigurationResource, please refer to the document of MonitoringMetricConfigurationResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            string roleName = "testrole";
            ResourceIdentifier monitoringMetricConfigurationResourceId = MonitoringMetricConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName, roleName);
            MonitoringMetricConfigurationResource monitoringMetricConfiguration = client.GetMonitoringMetricConfigurationResource(monitoringMetricConfigurationResourceId);

            // invoke the operation
            MonitoringMetricConfigurationResource result = await monitoringMetricConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitoringMetricConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PutMonitoringConfig
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PutMonitoringConfig()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/PutMonitoringConfig.json
            // this example is just showing the usage of "MonitoringConfig_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoringMetricConfigurationResource created on azure
            // for more information of creating MonitoringMetricConfigurationResource, please refer to the document of MonitoringMetricConfigurationResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            string roleName = "testrole";
            ResourceIdentifier monitoringMetricConfigurationResourceId = MonitoringMetricConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName, roleName);
            MonitoringMetricConfigurationResource monitoringMetricConfiguration = client.GetMonitoringMetricConfigurationResource(monitoringMetricConfigurationResourceId);

            // invoke the operation
            MonitoringMetricConfigurationData data = new MonitoringMetricConfigurationData(new DataBoxEdgeMetricConfiguration[]
            {
new DataBoxEdgeMetricConfiguration(new ResourceIdentifier("test"),new DataBoxEdgeMetricCounterSet[]
{
new DataBoxEdgeMetricCounterSet(new DataBoxEdgeMetricCounter[]
{
new DataBoxEdgeMetricCounter("test")
})
})
{
MdmAccount = "test",
MetricNameSpace = "test",
}
            });
            ArmOperation<MonitoringMetricConfigurationResource> lro = await monitoringMetricConfiguration.CreateOrUpdateAsync(WaitUntil.Completed, data);
            MonitoringMetricConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitoringMetricConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteMonitoringConfig
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteMonitoringConfig()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/DeleteMonitoringConfig.json
            // this example is just showing the usage of "MonitoringConfig_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoringMetricConfigurationResource created on azure
            // for more information of creating MonitoringMetricConfigurationResource, please refer to the document of MonitoringMetricConfigurationResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            string roleName = "testrole";
            ResourceIdentifier monitoringMetricConfigurationResourceId = MonitoringMetricConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName, roleName);
            MonitoringMetricConfigurationResource monitoringMetricConfiguration = client.GetMonitoringMetricConfigurationResource(monitoringMetricConfigurationResourceId);

            // invoke the operation
            await monitoringMetricConfiguration.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
