// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataBoxEdge.Models;

namespace Azure.ResourceManager.DataBoxEdge.Samples
{
    public partial class Sample_DataBoxEdgeOrderResource
    {
        // OrderGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_OrderGet()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/OrderGet.json
            // this example is just showing the usage of "Orders_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxEdgeOrderResource created on azure
            // for more information of creating DataBoxEdgeOrderResource, please refer to the document of DataBoxEdgeOrderResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            ResourceIdentifier dataBoxEdgeOrderResourceId = DataBoxEdgeOrderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName);
            DataBoxEdgeOrderResource dataBoxEdgeOrder = client.GetDataBoxEdgeOrderResource(dataBoxEdgeOrderResourceId);

            // invoke the operation
            DataBoxEdgeOrderResource result = await dataBoxEdgeOrder.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxEdgeOrderData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // OrderPut
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_OrderPut()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/OrderPut.json
            // this example is just showing the usage of "Orders_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxEdgeOrderResource created on azure
            // for more information of creating DataBoxEdgeOrderResource, please refer to the document of DataBoxEdgeOrderResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            ResourceIdentifier dataBoxEdgeOrderResourceId = DataBoxEdgeOrderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName);
            DataBoxEdgeOrderResource dataBoxEdgeOrder = client.GetDataBoxEdgeOrderResource(dataBoxEdgeOrderResourceId);

            // invoke the operation
            DataBoxEdgeOrderData data = new DataBoxEdgeOrderData()
            {
                ContactInformation = new DataBoxEdgeContactDetails("John Mcclane", "Microsoft", "(800) 426-9400", new string[]
            {
"john@microsoft.com"
            }),
                ShippingAddress = new DataBoxEdgeShippingAddress("USA")
                {
                    AddressLine1 = "Microsoft Corporation",
                    AddressLine2 = "One Microsoft Way",
                    AddressLine3 = "Redmond",
                    PostalCode = "98052",
                    City = "WA",
                    State = "WA",
                },
            };
            ArmOperation<DataBoxEdgeOrderResource> lro = await dataBoxEdgeOrder.CreateOrUpdateAsync(WaitUntil.Completed, data);
            DataBoxEdgeOrderResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxEdgeOrderData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // OrderDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_OrderDelete()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/OrderDelete.json
            // this example is just showing the usage of "Orders_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxEdgeOrderResource created on azure
            // for more information of creating DataBoxEdgeOrderResource, please refer to the document of DataBoxEdgeOrderResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            ResourceIdentifier dataBoxEdgeOrderResourceId = DataBoxEdgeOrderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName);
            DataBoxEdgeOrderResource dataBoxEdgeOrder = client.GetDataBoxEdgeOrderResource(dataBoxEdgeOrderResourceId);

            // invoke the operation
            await dataBoxEdgeOrder.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // GetDCAccessCode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataCenterAccessCode_GetDCAccessCode()
        {
            // Generated from example definition: specification/databoxedge/resource-manager/Microsoft.DataBoxEdge/stable/2022-03-01/examples/GetDCAccessCode.json
            // this example is just showing the usage of "Orders_ListDCAccessCode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxEdgeOrderResource created on azure
            // for more information of creating DataBoxEdgeOrderResource, please refer to the document of DataBoxEdgeOrderResource
            string subscriptionId = "4385cf00-2d3a-425a-832f-f4285b1c9dce";
            string resourceGroupName = "GroupForEdgeAutomation";
            string deviceName = "testedgedevice";
            ResourceIdentifier dataBoxEdgeOrderResourceId = DataBoxEdgeOrderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, deviceName);
            DataBoxEdgeOrderResource dataBoxEdgeOrder = client.GetDataBoxEdgeOrderResource(dataBoxEdgeOrderResourceId);

            // invoke the operation
            DataBoxEdgeDataCenterAccessCode result = await dataBoxEdgeOrder.GetDataCenterAccessCodeAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
