// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Job details for update. </summary>
    public partial class UpdateJobDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateJobDetails"/>. </summary>
        public UpdateJobDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateJobDetails"/>. </summary>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="reverseShippingDetails"> Reverse Shipping Address and contact details for a job. </param>
        /// <param name="preferences"> Preferences related to the order. </param>
        /// <param name="keyEncryptionKey"> Key encryption key for the job. </param>
        /// <param name="returnToCustomerPackageDetails"> Return package details of job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateJobDetails(DataBoxContactDetails contactDetails, DataBoxShippingAddress shippingAddress, ReverseShippingDetails reverseShippingDetails, DataBoxOrderPreferences preferences, DataBoxKeyEncryptionKey keyEncryptionKey, PackageCarrierDetails returnToCustomerPackageDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContactDetails = contactDetails;
            ShippingAddress = shippingAddress;
            ReverseShippingDetails = reverseShippingDetails;
            Preferences = preferences;
            KeyEncryptionKey = keyEncryptionKey;
            ReturnToCustomerPackageDetails = returnToCustomerPackageDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Contact details for notification and shipping. </summary>
        public DataBoxContactDetails ContactDetails { get; set; }
        /// <summary> Shipping address of the customer. </summary>
        public DataBoxShippingAddress ShippingAddress { get; set; }
        /// <summary> Reverse Shipping Address and contact details for a job. </summary>
        public ReverseShippingDetails ReverseShippingDetails { get; set; }
        /// <summary> Preferences related to the order. </summary>
        public DataBoxOrderPreferences Preferences { get; set; }
        /// <summary> Key encryption key for the job. </summary>
        public DataBoxKeyEncryptionKey KeyEncryptionKey { get; set; }
        /// <summary> Return package details of job. </summary>
        public PackageCarrierDetails ReturnToCustomerPackageDetails { get; set; }
    }
}
