// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Unknown version of JobSecrets. </summary>
    internal partial class UnknownJobSecrets : JobSecrets
    {
        /// <summary> Initializes a new instance of <see cref="UnknownJobSecrets"/>. </summary>
        /// <param name="jobSecretsType"> Used to indicate what type of job secrets object. </param>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownJobSecrets(DataBoxOrderType jobSecretsType, DataCenterAccessSecurityCode dataCenterAccessSecurityCode, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(jobSecretsType, dataCenterAccessSecurityCode, error, serializedAdditionalRawData)
        {
            JobSecretsType = jobSecretsType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownJobSecrets"/> for deserialization. </summary>
        internal UnknownJobSecrets()
        {
        }
    }
}
