// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class TransferConfigurationTypeExtensions
    {
        public static string ToSerialString(this TransferConfigurationType value) => value switch
        {
            TransferConfigurationType.TransferAll => "TransferAll",
            TransferConfigurationType.TransferUsingFilter => "TransferUsingFilter",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TransferConfigurationType value.")
        };

        public static TransferConfigurationType ToTransferConfigurationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TransferAll")) return TransferConfigurationType.TransferAll;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TransferUsingFilter")) return TransferConfigurationType.TransferUsingFilter;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TransferConfigurationType value.");
        }
    }
}
