// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter. </summary>
    internal partial class TransferConfigurationTransferFilterDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TransferConfigurationTransferFilterDetails"/>. </summary>
        public TransferConfigurationTransferFilterDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TransferConfigurationTransferFilterDetails"/>. </summary>
        /// <param name="include"> Details of the filtering the transfer of data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TransferConfigurationTransferFilterDetails(TransferFilterDetails include, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Include = include;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Details of the filtering the transfer of data. </summary>
        public TransferFilterDetails Include { get; set; }
    }
}
