// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Configuration for defining the transfer of data. </summary>
    public partial class TransferConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TransferConfiguration"/>. </summary>
        /// <param name="transferConfigurationType"> Type of the configuration for transfer. </param>
        public TransferConfiguration(TransferConfigurationType transferConfigurationType)
        {
            TransferConfigurationType = transferConfigurationType;
        }

        /// <summary> Initializes a new instance of <see cref="TransferConfiguration"/>. </summary>
        /// <param name="transferConfigurationType"> Type of the configuration for transfer. </param>
        /// <param name="transferFilterDetails"> Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter. </param>
        /// <param name="transferAllDetails"> Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TransferConfiguration(TransferConfigurationType transferConfigurationType, TransferConfigurationTransferFilterDetails transferFilterDetails, TransferConfigurationTransferAllDetails transferAllDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TransferConfigurationType = transferConfigurationType;
            TransferFilterDetails = transferFilterDetails;
            TransferAllDetails = transferAllDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TransferConfiguration"/> for deserialization. </summary>
        internal TransferConfiguration()
        {
        }

        /// <summary> Type of the configuration for transfer. </summary>
        public TransferConfigurationType TransferConfigurationType { get; set; }
        /// <summary> Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter. </summary>
        internal TransferConfigurationTransferFilterDetails TransferFilterDetails { get; set; }
        /// <summary> Details of the filtering the transfer of data. </summary>
        public TransferFilterDetails TransferFilterDetailsInclude
        {
            get => TransferFilterDetails is null ? default : TransferFilterDetails.Include;
            set
            {
                if (TransferFilterDetails is null)
                    TransferFilterDetails = new TransferConfigurationTransferFilterDetails();
                TransferFilterDetails.Include = value;
            }
        }

        /// <summary> Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll. </summary>
        internal TransferConfigurationTransferAllDetails TransferAllDetails { get; set; }
        /// <summary> Details to transfer all data. </summary>
        public TransferAllDetails TransferAllDetailsInclude
        {
            get => TransferAllDetails is null ? default : TransferAllDetails.Include;
            set
            {
                if (TransferAllDetails is null)
                    TransferAllDetails = new TransferConfigurationTransferAllDetails();
                TransferAllDetails.Include = value;
            }
        }
    }
}
