// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class SubscriptionIsAllowedToCreateJobValidationContent : IUtf8JsonSerializable, IJsonModel<SubscriptionIsAllowedToCreateJobValidationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SubscriptionIsAllowedToCreateJobValidationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SubscriptionIsAllowedToCreateJobValidationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubscriptionIsAllowedToCreateJobValidationContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        SubscriptionIsAllowedToCreateJobValidationContent IJsonModel<SubscriptionIsAllowedToCreateJobValidationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubscriptionIsAllowedToCreateJobValidationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSubscriptionIsAllowedToCreateJobValidationContent(document.RootElement, options);
        }

        internal static SubscriptionIsAllowedToCreateJobValidationContent DeserializeSubscriptionIsAllowedToCreateJobValidationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DataBoxValidationInputDiscriminator validationType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validationType"u8))
                {
                    validationType = property.Value.GetString().ToDataBoxValidationInputDiscriminator();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SubscriptionIsAllowedToCreateJobValidationContent(validationType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SubscriptionIsAllowedToCreateJobValidationContent)} does not support writing '{options.Format}' format.");
            }
        }

        SubscriptionIsAllowedToCreateJobValidationContent IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSubscriptionIsAllowedToCreateJobValidationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SubscriptionIsAllowedToCreateJobValidationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SubscriptionIsAllowedToCreateJobValidationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
