// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Reason why the Sku is disabled. </summary>
    public enum SkuDisabledReason
    {
        /// <summary> SKU is not disabled. </summary>
        None,
        /// <summary> SKU is not available in the requested country. </summary>
        Country,
        /// <summary> SKU is not available to push data to the requested Azure region. </summary>
        Region,
        /// <summary> Required features are not enabled for the SKU. </summary>
        Feature,
        /// <summary> Subscription does not have required offer types for the SKU. </summary>
        OfferType,
        /// <summary> Subscription has not registered to Microsoft.DataBox and Service does not have the subscription notification. </summary>
        NoSubscriptionInfo
    }
}
