// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class SkuDisabledReasonExtensions
    {
        public static string ToSerialString(this SkuDisabledReason value) => value switch
        {
            SkuDisabledReason.None => "None",
            SkuDisabledReason.Country => "Country",
            SkuDisabledReason.Region => "Region",
            SkuDisabledReason.Feature => "Feature",
            SkuDisabledReason.OfferType => "OfferType",
            SkuDisabledReason.NoSubscriptionInfo => "NoSubscriptionInfo",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SkuDisabledReason value.")
        };

        public static SkuDisabledReason ToSkuDisabledReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return SkuDisabledReason.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Country")) return SkuDisabledReason.Country;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Region")) return SkuDisabledReason.Region;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Feature")) return SkuDisabledReason.Feature;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "OfferType")) return SkuDisabledReason.OfferType;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NoSubscriptionInfo")) return SkuDisabledReason.NoSubscriptionInfo;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SkuDisabledReason value.");
        }
    }
}
