// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Properties of sku availability validation response. </summary>
    public partial class SkuAvailabilityValidationResult : DataBoxValidationInputResult
    {
        /// <summary> Initializes a new instance of <see cref="SkuAvailabilityValidationResult"/>. </summary>
        internal SkuAvailabilityValidationResult()
        {
            ValidationType = DataBoxValidationInputDiscriminator.ValidateSkuAvailability;
        }

        /// <summary> Initializes a new instance of <see cref="SkuAvailabilityValidationResult"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation response. </param>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> Sku availability validation status. </param>
        internal SkuAvailabilityValidationResult(DataBoxValidationInputDiscriminator validationType, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData, DataBoxValidationStatus? status) : base(validationType, error, serializedAdditionalRawData)
        {
            Status = status;
            ValidationType = validationType;
        }

        /// <summary> Sku availability validation status. </summary>
        public DataBoxValidationStatus? Status { get; }
    }
}
