// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Request to validate sku availability. </summary>
    public partial class SkuAvailabilityValidationContent : DataBoxValidationInputContent
    {
        /// <summary> Initializes a new instance of <see cref="SkuAvailabilityValidationContent"/>. </summary>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        /// <param name="country"> ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. </param>
        /// <param name="location"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="country"/> is null. </exception>
        public SkuAvailabilityValidationContent(DataBoxSkuName deviceType, DataBoxJobTransferType transferType, string country, AzureLocation location)
        {
            Argument.AssertNotNull(country, nameof(country));

            DeviceType = deviceType;
            TransferType = transferType;
            Country = country;
            Location = location;
            ValidationType = DataBoxValidationInputDiscriminator.ValidateSkuAvailability;
        }

        /// <summary> Initializes a new instance of <see cref="SkuAvailabilityValidationContent"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        /// <param name="country"> ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. </param>
        /// <param name="location"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        internal SkuAvailabilityValidationContent(DataBoxValidationInputDiscriminator validationType, IDictionary<string, BinaryData> serializedAdditionalRawData, DataBoxSkuName deviceType, DataBoxJobTransferType transferType, string country, AzureLocation location) : base(validationType, serializedAdditionalRawData)
        {
            DeviceType = deviceType;
            TransferType = transferType;
            Country = country;
            Location = location;
            ValidationType = validationType;
        }

        /// <summary> Initializes a new instance of <see cref="SkuAvailabilityValidationContent"/> for deserialization. </summary>
        internal SkuAvailabilityValidationContent()
        {
        }

        /// <summary> Device type to be used for the job. </summary>
        public DataBoxSkuName DeviceType { get; }
        /// <summary> Type of the transfer. </summary>
        public DataBoxJobTransferType TransferType { get; }
        /// <summary> ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. </summary>
        public string Country { get; }
        /// <summary> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </summary>
        public AzureLocation Location { get; }
    }
}
