// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class ShareDestinationFormatTypeExtensions
    {
        public static string ToSerialString(this ShareDestinationFormatType value) => value switch
        {
            ShareDestinationFormatType.UnknownType => "UnknownType",
            ShareDestinationFormatType.Hcs => "HCS",
            ShareDestinationFormatType.BlockBlob => "BlockBlob",
            ShareDestinationFormatType.PageBlob => "PageBlob",
            ShareDestinationFormatType.AzureFile => "AzureFile",
            ShareDestinationFormatType.ManagedDisk => "ManagedDisk",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareDestinationFormatType value.")
        };

        public static ShareDestinationFormatType ToShareDestinationFormatType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UnknownType")) return ShareDestinationFormatType.UnknownType;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "HCS")) return ShareDestinationFormatType.Hcs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BlockBlob")) return ShareDestinationFormatType.BlockBlob;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PageBlob")) return ShareDestinationFormatType.PageBlob;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureFile")) return ShareDestinationFormatType.AzureFile;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManagedDisk")) return ShareDestinationFormatType.ManagedDisk;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ShareDestinationFormatType value.");
        }
    }
}
