// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class OverallValidationStatusExtensions
    {
        public static string ToSerialString(this OverallValidationStatus value) => value switch
        {
            OverallValidationStatus.AllValidToProceed => "AllValidToProceed",
            OverallValidationStatus.InputsRevisitRequired => "InputsRevisitRequired",
            OverallValidationStatus.CertainInputValidationsSkipped => "CertainInputValidationsSkipped",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown OverallValidationStatus value.")
        };

        public static OverallValidationStatus ToOverallValidationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AllValidToProceed")) return OverallValidationStatus.AllValidToProceed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InputsRevisitRequired")) return OverallValidationStatus.InputsRevisitRequired;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CertainInputValidationsSkipped")) return OverallValidationStatus.CertainInputValidationsSkipped;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown OverallValidationStatus value.");
        }
    }
}
