// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> The request body to provide the delivery package details of job. </summary>
    public partial class MarkDevicesShippedContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MarkDevicesShippedContent"/>. </summary>
        /// <param name="deliverToDataCenterPackageDetails"> Delivery package details. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="deliverToDataCenterPackageDetails"/> is null. </exception>
        public MarkDevicesShippedContent(PackageCarrierInfo deliverToDataCenterPackageDetails)
        {
            Argument.AssertNotNull(deliverToDataCenterPackageDetails, nameof(deliverToDataCenterPackageDetails));

            DeliverToDataCenterPackageDetails = deliverToDataCenterPackageDetails;
        }

        /// <summary> Initializes a new instance of <see cref="MarkDevicesShippedContent"/>. </summary>
        /// <param name="deliverToDataCenterPackageDetails"> Delivery package details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MarkDevicesShippedContent(PackageCarrierInfo deliverToDataCenterPackageDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeliverToDataCenterPackageDetails = deliverToDataCenterPackageDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MarkDevicesShippedContent"/> for deserialization. </summary>
        internal MarkDevicesShippedContent()
        {
        }

        /// <summary> Delivery package details. </summary>
        public PackageCarrierInfo DeliverToDataCenterPackageDetails { get; }
    }
}
