// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class LogCollectionLevelExtensions
    {
        public static string ToSerialString(this LogCollectionLevel value) => value switch
        {
            LogCollectionLevel.Error => "Error",
            LogCollectionLevel.Verbose => "Verbose",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LogCollectionLevel value.")
        };

        public static LogCollectionLevel ToLogCollectionLevel(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Error")) return LogCollectionLevel.Error;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Verbose")) return LogCollectionLevel.Verbose;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LogCollectionLevel value.");
        }
    }
}
