// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Last Mitigation Action Performed On Job. </summary>
    public partial class LastMitigationActionOnJob
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LastMitigationActionOnJob"/>. </summary>
        internal LastMitigationActionOnJob()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LastMitigationActionOnJob"/>. </summary>
        /// <param name="actionPerformedOn"> Action performed date time. </param>
        /// <param name="isPerformedByCustomer">
        /// Action performed by customer,
        /// possibility is that mitigation might happen by customer or service or by ops
        /// </param>
        /// <param name="customerResolution"> Resolution code provided by customer. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LastMitigationActionOnJob(DateTimeOffset? actionPerformedOn, bool? isPerformedByCustomer, CustomerResolutionCode? customerResolution, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionPerformedOn = actionPerformedOn;
            IsPerformedByCustomer = isPerformedByCustomer;
            CustomerResolution = customerResolution;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Action performed date time. </summary>
        public DateTimeOffset? ActionPerformedOn { get; }
        /// <summary>
        /// Action performed by customer,
        /// possibility is that mitigation might happen by customer or service or by ops
        /// </summary>
        public bool? IsPerformedByCustomer { get; }
        /// <summary> Resolution code provided by customer. </summary>
        public CustomerResolutionCode? CustomerResolution { get; }
    }
}
