// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class JobDeliveryTypeExtensions
    {
        public static string ToSerialString(this JobDeliveryType value) => value switch
        {
            JobDeliveryType.NonScheduled => "NonScheduled",
            JobDeliveryType.Scheduled => "Scheduled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown JobDeliveryType value.")
        };

        public static JobDeliveryType ToJobDeliveryType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NonScheduled")) return JobDeliveryType.NonScheduled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Scheduled")) return JobDeliveryType.Scheduled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown JobDeliveryType value.");
        }
    }
}
