// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class ImportDiskDetails : IUtf8JsonSerializable, IJsonModel<ImportDiskDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImportDiskDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImportDiskDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportDiskDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImportDiskDetails)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("manifestFile"u8);
            writer.WriteStringValue(ManifestFile);
            writer.WritePropertyName("manifestHash"u8);
            writer.WriteStringValue(ManifestHash);
            writer.WritePropertyName("bitLockerKey"u8);
            writer.WriteStringValue(BitLockerKey);
            if (options.Format != "W" && Optional.IsDefined(BackupManifestCloudPath))
            {
                writer.WritePropertyName("backupManifestCloudPath"u8);
                writer.WriteStringValue(BackupManifestCloudPath);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ImportDiskDetails IJsonModel<ImportDiskDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportDiskDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImportDiskDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImportDiskDetails(document.RootElement, options);
        }

        internal static ImportDiskDetails DeserializeImportDiskDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string manifestFile = default;
            string manifestHash = default;
            string bitLockerKey = default;
            string backupManifestCloudPath = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("manifestFile"u8))
                {
                    manifestFile = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("manifestHash"u8))
                {
                    manifestHash = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bitLockerKey"u8))
                {
                    bitLockerKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("backupManifestCloudPath"u8))
                {
                    backupManifestCloudPath = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImportDiskDetails(manifestFile, manifestHash, bitLockerKey, backupManifestCloudPath, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ImportDiskDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportDiskDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ImportDiskDetails)} does not support writing '{options.Format}' format.");
            }
        }

        ImportDiskDetails IPersistableModel<ImportDiskDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportDiskDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImportDiskDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImportDiskDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImportDiskDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
