// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class HardwareEncryptionExtensions
    {
        public static string ToSerialString(this HardwareEncryption value) => value switch
        {
            HardwareEncryption.Enabled => "Enabled",
            HardwareEncryption.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HardwareEncryption value.")
        };

        public static HardwareEncryption ToHardwareEncryption(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return HardwareEncryption.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return HardwareEncryption.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HardwareEncryption value.");
        }
    }
}
