// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class FilterFileTypeExtensions
    {
        public static string ToSerialString(this FilterFileType value) => value switch
        {
            FilterFileType.AzureBlob => "AzureBlob",
            FilterFileType.AzureFile => "AzureFile",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilterFileType value.")
        };

        public static FilterFileType ToFilterFileType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureBlob")) return FilterFileType.AzureBlob;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureFile")) return FilterFileType.AzureFile;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FilterFileType value.");
        }
    }
}
