// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class DeviceErasureDetails : IUtf8JsonSerializable, IJsonModel<DeviceErasureDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeviceErasureDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeviceErasureDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceErasureDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceErasureDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(DeviceErasureStatus))
            {
                writer.WritePropertyName("deviceErasureStatus"u8);
                writer.WriteStringValue(DeviceErasureStatus.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(ErasureOrDestructionCertificateSasKey))
            {
                writer.WritePropertyName("erasureOrDestructionCertificateSasKey"u8);
                writer.WriteStringValue(ErasureOrDestructionCertificateSasKey);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeviceErasureDetails IJsonModel<DeviceErasureDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceErasureDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceErasureDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeviceErasureDetails(document.RootElement, options);
        }

        internal static DeviceErasureDetails DeserializeDeviceErasureDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DataBoxStageStatus? deviceErasureStatus = default;
            string erasureOrDestructionCertificateSasKey = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceErasureStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deviceErasureStatus = property.Value.GetString().ToDataBoxStageStatus();
                    continue;
                }
                if (property.NameEquals("erasureOrDestructionCertificateSasKey"u8))
                {
                    erasureOrDestructionCertificateSasKey = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeviceErasureDetails(deviceErasureStatus, erasureOrDestructionCertificateSasKey, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DeviceErasureDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceErasureDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DeviceErasureDetails)} does not support writing '{options.Format}' format.");
            }
        }

        DeviceErasureDetails IPersistableModel<DeviceErasureDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceErasureDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeviceErasureDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeviceErasureDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeviceErasureDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
