// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Properties of data transfer details validation response. </summary>
    public partial class DataTransferDetailsValidationResult : DataBoxValidationInputResult
    {
        /// <summary> Initializes a new instance of <see cref="DataTransferDetailsValidationResult"/>. </summary>
        internal DataTransferDetailsValidationResult()
        {
            ValidationType = DataBoxValidationInputDiscriminator.ValidateDataTransferDetails;
        }

        /// <summary> Initializes a new instance of <see cref="DataTransferDetailsValidationResult"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation response. </param>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> Data transfer details validation status. </param>
        internal DataTransferDetailsValidationResult(DataBoxValidationInputDiscriminator validationType, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData, DataBoxValidationStatus? status) : base(validationType, error, serializedAdditionalRawData)
        {
            Status = status;
            ValidationType = validationType;
        }

        /// <summary> Data transfer details validation status. </summary>
        public DataBoxValidationStatus? Status { get; }
    }
}
