// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Request to validate export and import data details. </summary>
    public partial class DataTransferDetailsValidationContent : DataBoxValidationInputContent
    {
        /// <summary> Initializes a new instance of <see cref="DataTransferDetailsValidationContent"/>. </summary>
        /// <param name="deviceType"> Device type. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        public DataTransferDetailsValidationContent(DataBoxSkuName deviceType, DataBoxJobTransferType transferType)
        {
            DataExportDetails = new ChangeTrackingList<DataExportDetails>();
            DataImportDetails = new ChangeTrackingList<DataImportDetails>();
            DeviceType = deviceType;
            TransferType = transferType;
            ValidationType = DataBoxValidationInputDiscriminator.ValidateDataTransferDetails;
        }

        /// <summary> Initializes a new instance of <see cref="DataTransferDetailsValidationContent"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dataExportDetails"> List of DataTransfer details to be used to export data from azure. </param>
        /// <param name="dataImportDetails"> List of DataTransfer details to be used to import data to azure. </param>
        /// <param name="deviceType"> Device type. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        internal DataTransferDetailsValidationContent(DataBoxValidationInputDiscriminator validationType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<DataExportDetails> dataExportDetails, IList<DataImportDetails> dataImportDetails, DataBoxSkuName deviceType, DataBoxJobTransferType transferType) : base(validationType, serializedAdditionalRawData)
        {
            DataExportDetails = dataExportDetails;
            DataImportDetails = dataImportDetails;
            DeviceType = deviceType;
            TransferType = transferType;
            ValidationType = validationType;
        }

        /// <summary> Initializes a new instance of <see cref="DataTransferDetailsValidationContent"/> for deserialization. </summary>
        internal DataTransferDetailsValidationContent()
        {
        }

        /// <summary> List of DataTransfer details to be used to export data from azure. </summary>
        public IList<DataExportDetails> DataExportDetails { get; }
        /// <summary> List of DataTransfer details to be used to import data to azure. </summary>
        public IList<DataImportDetails> DataImportDetails { get; }
        /// <summary> Device type. </summary>
        public DataBoxSkuName DeviceType { get; }
        /// <summary> Type of the transfer. </summary>
        public DataBoxJobTransferType TransferType { get; }
    }
}
