// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataCenterAddressTypeExtensions
    {
        public static string ToSerialString(this DataCenterAddressType value) => value switch
        {
            DataCenterAddressType.DataCenterAddressLocation => "DatacenterAddressLocation",
            DataCenterAddressType.DataCenterAddressInstruction => "DatacenterAddressInstruction",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataCenterAddressType value.")
        };

        public static DataCenterAddressType ToDataCenterAddressType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DatacenterAddressLocation")) return DataCenterAddressType.DataCenterAddressLocation;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DatacenterAddressInstruction")) return DataCenterAddressType.DataCenterAddressInstruction;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataCenterAddressType value.");
        }
    }
}
