// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary>
    /// Datacenter address for given storage location.
    /// Please note <see cref="DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="DataCenterAddressInstructionResult"/> and <see cref="DataCenterAddressLocationResult"/>.
    /// </summary>
    public abstract partial class DataCenterAddressResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataCenterAddressResult"/>. </summary>
        protected DataCenterAddressResult()
        {
            SupportedCarriersForReturnShipment = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DataCenterAddressResult"/>. </summary>
        /// <param name="dataCenterAddressType"> Data center address type. </param>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataCenterAddressResult(DataCenterAddressType dataCenterAddressType, IReadOnlyList<string> supportedCarriersForReturnShipment, AzureLocation? dataCenterAzureLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataCenterAddressType = dataCenterAddressType;
            SupportedCarriersForReturnShipment = supportedCarriersForReturnShipment;
            DataCenterAzureLocation = dataCenterAzureLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Data center address type. </summary>
        internal DataCenterAddressType DataCenterAddressType { get; set; }
        /// <summary> List of supported carriers for return shipment. </summary>
        public IReadOnlyList<string> SupportedCarriersForReturnShipment { get; }
        /// <summary> Azure Location where the Data Center serves primarily. </summary>
        public AzureLocation? DataCenterAzureLocation { get; }
    }
}
