// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Datacenter address for given storage location. </summary>
    public partial class DataCenterAddressLocationResult : DataCenterAddressResult
    {
        /// <summary> Initializes a new instance of <see cref="DataCenterAddressLocationResult"/>. </summary>
        internal DataCenterAddressLocationResult()
        {
            DataCenterAddressType = DataCenterAddressType.DataCenterAddressLocation;
        }

        /// <summary> Initializes a new instance of <see cref="DataCenterAddressLocationResult"/>. </summary>
        /// <param name="dataCenterAddressType"> Data center address type. </param>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="contactPersonName"> Contact person name. </param>
        /// <param name="company"> Company name. </param>
        /// <param name="street1"> Street address line 1. </param>
        /// <param name="street2"> Street address line 2. </param>
        /// <param name="street3"> Street address line 3. </param>
        /// <param name="city"> City name. </param>
        /// <param name="state"> name of the state. </param>
        /// <param name="zip"> Zip code. </param>
        /// <param name="country"> name of the country. </param>
        /// <param name="phone"> Phone number. </param>
        /// <param name="phoneExtension"> Phone extension. </param>
        /// <param name="addressType"> Address type. </param>
        /// <param name="additionalShippingInformation"> Special instruction for shipping. </param>
        internal DataCenterAddressLocationResult(DataCenterAddressType dataCenterAddressType, IReadOnlyList<string> supportedCarriersForReturnShipment, AzureLocation? dataCenterAzureLocation, IDictionary<string, BinaryData> serializedAdditionalRawData, string contactPersonName, string company, string street1, string street2, string street3, string city, string state, string zip, string country, string phone, string phoneExtension, string addressType, string additionalShippingInformation) : base(dataCenterAddressType, supportedCarriersForReturnShipment, dataCenterAzureLocation, serializedAdditionalRawData)
        {
            ContactPersonName = contactPersonName;
            Company = company;
            Street1 = street1;
            Street2 = street2;
            Street3 = street3;
            City = city;
            State = state;
            Zip = zip;
            Country = country;
            Phone = phone;
            PhoneExtension = phoneExtension;
            AddressType = addressType;
            AdditionalShippingInformation = additionalShippingInformation;
            DataCenterAddressType = dataCenterAddressType;
        }

        /// <summary> Contact person name. </summary>
        public string ContactPersonName { get; }
        /// <summary> Company name. </summary>
        public string Company { get; }
        /// <summary> Street address line 1. </summary>
        public string Street1 { get; }
        /// <summary> Street address line 2. </summary>
        public string Street2 { get; }
        /// <summary> Street address line 3. </summary>
        public string Street3 { get; }
        /// <summary> City name. </summary>
        public string City { get; }
        /// <summary> name of the state. </summary>
        public string State { get; }
        /// <summary> Zip code. </summary>
        public string Zip { get; }
        /// <summary> name of the country. </summary>
        public string Country { get; }
        /// <summary> Phone number. </summary>
        public string Phone { get; }
        /// <summary> Phone extension. </summary>
        public string PhoneExtension { get; }
        /// <summary> Address type. </summary>
        public string AddressType { get; }
        /// <summary> Special instruction for shipping. </summary>
        public string AdditionalShippingInformation { get; }
    }
}
