// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Datacenter instruction for given storage location. </summary>
    public partial class DataCenterAddressInstructionResult : DataCenterAddressResult
    {
        /// <summary> Initializes a new instance of <see cref="DataCenterAddressInstructionResult"/>. </summary>
        internal DataCenterAddressInstructionResult()
        {
            DataCenterAddressType = DataCenterAddressType.DataCenterAddressInstruction;
        }

        /// <summary> Initializes a new instance of <see cref="DataCenterAddressInstructionResult"/>. </summary>
        /// <param name="dataCenterAddressType"> Data center address type. </param>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="communicationInstruction"> Data center communication instruction. </param>
        internal DataCenterAddressInstructionResult(DataCenterAddressType dataCenterAddressType, IReadOnlyList<string> supportedCarriersForReturnShipment, AzureLocation? dataCenterAzureLocation, IDictionary<string, BinaryData> serializedAdditionalRawData, string communicationInstruction) : base(dataCenterAddressType, supportedCarriersForReturnShipment, dataCenterAzureLocation, serializedAdditionalRawData)
        {
            CommunicationInstruction = communicationInstruction;
            DataCenterAddressType = dataCenterAddressType;
        }

        /// <summary> Data center communication instruction. </summary>
        public string CommunicationInstruction { get; }
    }
}
