// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class DataCenterAccessSecurityCode : IUtf8JsonSerializable, IJsonModel<DataCenterAccessSecurityCode>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataCenterAccessSecurityCode>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataCenterAccessSecurityCode>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataCenterAccessSecurityCode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataCenterAccessSecurityCode)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ReverseDataCenterAccessCode))
            {
                writer.WritePropertyName("reverseDCAccessCode"u8);
                writer.WriteStringValue(ReverseDataCenterAccessCode);
            }
            if (Optional.IsDefined(ForwardDataCenterAccessCode))
            {
                writer.WritePropertyName("forwardDCAccessCode"u8);
                writer.WriteStringValue(ForwardDataCenterAccessCode);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataCenterAccessSecurityCode IJsonModel<DataCenterAccessSecurityCode>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataCenterAccessSecurityCode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataCenterAccessSecurityCode)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataCenterAccessSecurityCode(document.RootElement, options);
        }

        internal static DataCenterAccessSecurityCode DeserializeDataCenterAccessSecurityCode(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string reverseDCAccessCode = default;
            string forwardDCAccessCode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("reverseDCAccessCode"u8))
                {
                    reverseDCAccessCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("forwardDCAccessCode"u8))
                {
                    forwardDCAccessCode = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataCenterAccessSecurityCode(reverseDCAccessCode, forwardDCAccessCode, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataCenterAccessSecurityCode>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataCenterAccessSecurityCode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataCenterAccessSecurityCode)} does not support writing '{options.Format}' format.");
            }
        }

        DataCenterAccessSecurityCode IPersistableModel<DataCenterAccessSecurityCode>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataCenterAccessSecurityCode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataCenterAccessSecurityCode(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataCenterAccessSecurityCode)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataCenterAccessSecurityCode>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
