// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxValidationStatusExtensions
    {
        public static string ToSerialString(this DataBoxValidationStatus value) => value switch
        {
            DataBoxValidationStatus.Valid => "Valid",
            DataBoxValidationStatus.Invalid => "Invalid",
            DataBoxValidationStatus.Skipped => "Skipped",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxValidationStatus value.")
        };

        public static DataBoxValidationStatus ToDataBoxValidationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Valid")) return DataBoxValidationStatus.Valid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return DataBoxValidationStatus.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Skipped")) return DataBoxValidationStatus.Skipped;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxValidationStatus value.");
        }
    }
}
