// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxValidationInputDiscriminatorExtensions
    {
        public static string ToSerialString(this DataBoxValidationInputDiscriminator value) => value switch
        {
            DataBoxValidationInputDiscriminator.ValidateAddress => "ValidateAddress",
            DataBoxValidationInputDiscriminator.ValidateSubscriptionIsAllowedToCreateJob => "ValidateSubscriptionIsAllowedToCreateJob",
            DataBoxValidationInputDiscriminator.ValidatePreferences => "ValidatePreferences",
            DataBoxValidationInputDiscriminator.ValidateCreateOrderLimit => "ValidateCreateOrderLimit",
            DataBoxValidationInputDiscriminator.ValidateSkuAvailability => "ValidateSkuAvailability",
            DataBoxValidationInputDiscriminator.ValidateDataTransferDetails => "ValidateDataTransferDetails",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxValidationInputDiscriminator value.")
        };

        public static DataBoxValidationInputDiscriminator ToDataBoxValidationInputDiscriminator(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateAddress")) return DataBoxValidationInputDiscriminator.ValidateAddress;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateSubscriptionIsAllowedToCreateJob")) return DataBoxValidationInputDiscriminator.ValidateSubscriptionIsAllowedToCreateJob;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidatePreferences")) return DataBoxValidationInputDiscriminator.ValidatePreferences;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateCreateOrderLimit")) return DataBoxValidationInputDiscriminator.ValidateCreateOrderLimit;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateSkuAvailability")) return DataBoxValidationInputDiscriminator.ValidateSkuAvailability;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateDataTransferDetails")) return DataBoxValidationInputDiscriminator.ValidateDataTransferDetails;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxValidationInputDiscriminator value.");
        }
    }
}
