// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Identify the nature of validation. </summary>
    internal readonly partial struct DataBoxValidationCategory : IEquatable<DataBoxValidationCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataBoxValidationCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataBoxValidationCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JobCreationValidationValue = "JobCreationValidation";

        /// <summary> JobCreationValidation. </summary>
        public static DataBoxValidationCategory JobCreationValidation { get; } = new DataBoxValidationCategory(JobCreationValidationValue);
        /// <summary> Determines if two <see cref="DataBoxValidationCategory"/> values are the same. </summary>
        public static bool operator ==(DataBoxValidationCategory left, DataBoxValidationCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataBoxValidationCategory"/> values are not the same. </summary>
        public static bool operator !=(DataBoxValidationCategory left, DataBoxValidationCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataBoxValidationCategory"/>. </summary>
        public static implicit operator DataBoxValidationCategory(string value) => new DataBoxValidationCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataBoxValidationCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataBoxValidationCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
