// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxStageStatusExtensions
    {
        public static string ToSerialString(this DataBoxStageStatus value) => value switch
        {
            DataBoxStageStatus.None => "None",
            DataBoxStageStatus.InProgress => "InProgress",
            DataBoxStageStatus.Succeeded => "Succeeded",
            DataBoxStageStatus.Failed => "Failed",
            DataBoxStageStatus.Cancelled => "Cancelled",
            DataBoxStageStatus.Cancelling => "Cancelling",
            DataBoxStageStatus.SucceededWithErrors => "SucceededWithErrors",
            DataBoxStageStatus.WaitingForCustomerAction => "WaitingForCustomerAction",
            DataBoxStageStatus.SucceededWithWarnings => "SucceededWithWarnings",
            DataBoxStageStatus.WaitingForCustomerActionForKek => "WaitingForCustomerActionForKek",
            DataBoxStageStatus.WaitingForCustomerActionForCleanUp => "WaitingForCustomerActionForCleanUp",
            DataBoxStageStatus.CustomerActionPerformedForCleanUp => "CustomerActionPerformedForCleanUp",
            DataBoxStageStatus.CustomerActionPerformed => "CustomerActionPerformed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxStageStatus value.")
        };

        public static DataBoxStageStatus ToDataBoxStageStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return DataBoxStageStatus.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InProgress")) return DataBoxStageStatus.InProgress;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return DataBoxStageStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return DataBoxStageStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cancelled")) return DataBoxStageStatus.Cancelled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cancelling")) return DataBoxStageStatus.Cancelling;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SucceededWithErrors")) return DataBoxStageStatus.SucceededWithErrors;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "WaitingForCustomerAction")) return DataBoxStageStatus.WaitingForCustomerAction;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SucceededWithWarnings")) return DataBoxStageStatus.SucceededWithWarnings;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "WaitingForCustomerActionForKek")) return DataBoxStageStatus.WaitingForCustomerActionForKek;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "WaitingForCustomerActionForCleanUp")) return DataBoxStageStatus.WaitingForCustomerActionForCleanUp;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CustomerActionPerformedForCleanUp")) return DataBoxStageStatus.CustomerActionPerformedForCleanUp;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CustomerActionPerformed")) return DataBoxStageStatus.CustomerActionPerformed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxStageStatus value.");
        }
    }
}
