// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxSkuNameExtensions
    {
        public static string ToSerialString(this DataBoxSkuName value) => value switch
        {
            DataBoxSkuName.DataBox => "DataBox",
            DataBoxSkuName.DataBoxDisk => "DataBoxDisk",
            DataBoxSkuName.DataBoxHeavy => "DataBoxHeavy",
            DataBoxSkuName.DataBoxCustomerDisk => "DataBoxCustomerDisk",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxSkuName value.")
        };

        public static DataBoxSkuName ToDataBoxSkuName(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBox")) return DataBoxSkuName.DataBox;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxDisk")) return DataBoxSkuName.DataBoxDisk;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxHeavy")) return DataBoxSkuName.DataBoxHeavy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxCustomerDisk")) return DataBoxSkuName.DataBoxCustomerDisk;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxSkuName value.");
        }
    }
}
