// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Capacity of the sku. </summary>
    public partial class DataBoxSkuCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxSkuCapacity"/>. </summary>
        internal DataBoxSkuCapacity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxSkuCapacity"/>. </summary>
        /// <param name="usable"> Usable capacity in TB. </param>
        /// <param name="maximum"> Maximum capacity in TB. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxSkuCapacity(string usable, string maximum, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Usable = usable;
            Maximum = maximum;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Usable capacity in TB. </summary>
        public string Usable { get; }
        /// <summary> Maximum capacity in TB. </summary>
        public string Maximum { get; }
    }
}
