// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxShippingAddressTypeExtensions
    {
        public static string ToSerialString(this DataBoxShippingAddressType value) => value switch
        {
            DataBoxShippingAddressType.None => "None",
            DataBoxShippingAddressType.Residential => "Residential",
            DataBoxShippingAddressType.Commercial => "Commercial",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxShippingAddressType value.")
        };

        public static DataBoxShippingAddressType ToDataBoxShippingAddressType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return DataBoxShippingAddressType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Residential")) return DataBoxShippingAddressType.Residential;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commercial")) return DataBoxShippingAddressType.Commercial;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxShippingAddressType value.");
        }
    }
}
