// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Shipping address where customer wishes to receive the device. </summary>
    public partial class DataBoxShippingAddress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxShippingAddress"/>. </summary>
        /// <param name="streetAddress1"> Street Address line 1. </param>
        /// <param name="country"> Name of the Country. </param>
        /// <param name="postalCode"> Postal code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="streetAddress1"/>, <paramref name="country"/> or <paramref name="postalCode"/> is null. </exception>
        public DataBoxShippingAddress(string streetAddress1, string country, string postalCode)
        {
            Argument.AssertNotNull(streetAddress1, nameof(streetAddress1));
            Argument.AssertNotNull(country, nameof(country));
            Argument.AssertNotNull(postalCode, nameof(postalCode));

            StreetAddress1 = streetAddress1;
            Country = country;
            PostalCode = postalCode;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxShippingAddress"/>. </summary>
        /// <param name="streetAddress1"> Street Address line 1. </param>
        /// <param name="streetAddress2"> Street Address line 2. </param>
        /// <param name="streetAddress3"> Street Address line 3. </param>
        /// <param name="city"> Name of the City. </param>
        /// <param name="stateOrProvince"> Name of the State or Province. </param>
        /// <param name="country"> Name of the Country. </param>
        /// <param name="postalCode"> Postal code. </param>
        /// <param name="zipExtendedCode"> Extended Zip Code. </param>
        /// <param name="companyName"> Name of the company. </param>
        /// <param name="addressType"> Type of address. </param>
        /// <param name="skipAddressValidation"> Flag to indicate if customer has chosen to skip default address validation. </param>
        /// <param name="taxIdentificationNumber"> Tax Identification Number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxShippingAddress(string streetAddress1, string streetAddress2, string streetAddress3, string city, string stateOrProvince, string country, string postalCode, string zipExtendedCode, string companyName, DataBoxShippingAddressType? addressType, bool? skipAddressValidation, string taxIdentificationNumber, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StreetAddress1 = streetAddress1;
            StreetAddress2 = streetAddress2;
            StreetAddress3 = streetAddress3;
            City = city;
            StateOrProvince = stateOrProvince;
            Country = country;
            PostalCode = postalCode;
            ZipExtendedCode = zipExtendedCode;
            CompanyName = companyName;
            AddressType = addressType;
            SkipAddressValidation = skipAddressValidation;
            TaxIdentificationNumber = taxIdentificationNumber;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxShippingAddress"/> for deserialization. </summary>
        internal DataBoxShippingAddress()
        {
        }

        /// <summary> Street Address line 1. </summary>
        public string StreetAddress1 { get; set; }
        /// <summary> Street Address line 2. </summary>
        public string StreetAddress2 { get; set; }
        /// <summary> Street Address line 3. </summary>
        public string StreetAddress3 { get; set; }
        /// <summary> Name of the City. </summary>
        public string City { get; set; }
        /// <summary> Name of the State or Province. </summary>
        public string StateOrProvince { get; set; }
        /// <summary> Name of the Country. </summary>
        public string Country { get; set; }
        /// <summary> Postal code. </summary>
        public string PostalCode { get; set; }
        /// <summary> Extended Zip Code. </summary>
        public string ZipExtendedCode { get; set; }
        /// <summary> Name of the company. </summary>
        public string CompanyName { get; set; }
        /// <summary> Type of address. </summary>
        public DataBoxShippingAddressType? AddressType { get; set; }
        /// <summary> Flag to indicate if customer has chosen to skip default address validation. </summary>
        public bool? SkipAddressValidation { get; set; }
        /// <summary> Tax Identification Number. </summary>
        public string TaxIdentificationNumber { get; set; }
    }
}
