// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxOrderTypeExtensions
    {
        public static string ToSerialString(this DataBoxOrderType value) => value switch
        {
            DataBoxOrderType.DataBox => "DataBox",
            DataBoxOrderType.DataBoxDisk => "DataBoxDisk",
            DataBoxOrderType.DataBoxHeavy => "DataBoxHeavy",
            DataBoxOrderType.DataBoxCustomerDisk => "DataBoxCustomerDisk",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxOrderType value.")
        };

        public static DataBoxOrderType ToDataBoxOrderType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBox")) return DataBoxOrderType.DataBox;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxDisk")) return DataBoxOrderType.DataBoxDisk;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxHeavy")) return DataBoxOrderType.DataBoxHeavy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataBoxCustomerDisk")) return DataBoxOrderType.DataBoxCustomerDisk;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxOrderType value.");
        }
    }
}
