// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxKeyEncryptionKeyTypeExtensions
    {
        public static string ToSerialString(this DataBoxKeyEncryptionKeyType value) => value switch
        {
            DataBoxKeyEncryptionKeyType.MicrosoftManaged => "MicrosoftManaged",
            DataBoxKeyEncryptionKeyType.CustomerManaged => "CustomerManaged",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxKeyEncryptionKeyType value.")
        };

        public static DataBoxKeyEncryptionKeyType ToDataBoxKeyEncryptionKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MicrosoftManaged")) return DataBoxKeyEncryptionKeyType.MicrosoftManaged;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CustomerManaged")) return DataBoxKeyEncryptionKeyType.CustomerManaged;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxKeyEncryptionKeyType value.");
        }
    }
}
