// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataBoxJobTransferTypeExtensions
    {
        public static string ToSerialString(this DataBoxJobTransferType value) => value switch
        {
            DataBoxJobTransferType.ImportToAzure => "ImportToAzure",
            DataBoxJobTransferType.ExportFromAzure => "ExportFromAzure",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxJobTransferType value.")
        };

        public static DataBoxJobTransferType ToDataBoxJobTransferType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ImportToAzure")) return DataBoxJobTransferType.ImportToAzure;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ExportFromAzure")) return DataBoxJobTransferType.ExportFromAzure;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataBoxJobTransferType value.");
        }
    }
}
