// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Preferences related to the Encryption. </summary>
    public partial class DataBoxEncryptionPreferences
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxEncryptionPreferences"/>. </summary>
        public DataBoxEncryptionPreferences()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxEncryptionPreferences"/>. </summary>
        /// <param name="doubleEncryption"> Defines secondary layer of software-based encryption enablement. </param>
        /// <param name="hardwareEncryption"> Defines Hardware level encryption (Only for disk). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxEncryptionPreferences(DataBoxDoubleEncryption? doubleEncryption, HardwareEncryption? hardwareEncryption, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DoubleEncryption = doubleEncryption;
            HardwareEncryption = hardwareEncryption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Defines secondary layer of software-based encryption enablement. </summary>
        public DataBoxDoubleEncryption? DoubleEncryption { get; set; }
        /// <summary> Defines Hardware level encryption (Only for disk). </summary>
        public HardwareEncryption? HardwareEncryption { get; set; }
    }
}
